﻿using System;
using System.Diagnostics;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Shapes;
using static System.Math;

namespace DemoAdam
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public double Coeff;
        public double[] Tableau = new double[2];
        public MainWindow()
        {
            InitializeComponent();
            TB1.Text = "Bonjour Adam";
        }

        Polyline myPolyLineSinLinSinusCA = new Polyline(); // Créer la Polyline
        Polyline myPolyLine = new Polyline(); // Créer la Polyline
        Polyline myPolyLineSinLinSinusCD = new Polyline(); // Créer la Polyline



        private void EnfinAffiche(object sender, RoutedEventArgs e)
        {
            rampSlider.Value = 0.25;
        }
        public void DisplayCurveJAccContinu(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLine);  // Dessine la Polylinemain

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasJ.ActualWidth; i++)
            {
                myPoint.X = i;

                if (i/ canvasJ.ActualWidth<ramp && (i+1) / canvasJ.ActualWidth >= ramp)
                {
                    myPoint.Y = 0;
                }
                else
                {
                    if (i / canvasJ.ActualWidth < 1- ramp && (i+1) / canvasJ.ActualWidth >= 1- ramp)
                    {
                        myPoint.Y = canvasD.ActualHeight;
                    }
                    else
                    { 
                        myPoint.Y = 0.5 * canvasD.ActualHeight;
                    }
                }
                CurveCollection2.Add(myPoint);
            }
            Point Tmp = new Point(0, canvasD.ActualHeight);
            CurveCollection2[0] = Tmp;
            Tmp.X = canvasD.ActualWidth;
            Tmp.Y = 0;
            CurveCollection2[CurveCollection2.Count - 1] = Tmp;
            

            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Red;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveAAccContinu(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasA.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculAccelerationAccConctinu(i / canvasD.ActualWidth, ramp)* canvasA.ActualHeight / 2 + canvasA.ActualHeight/2;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Red;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveVAccContinu(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasV.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculVitesseAccConctinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Red;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveDAccContinu(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasD.ActualWidth; i++)

            {
                myPoint.X = i;
                myPoint.Y = (CalculDistanceAccConctinu(i / canvasD.ActualWidth, ramp)) * canvasD.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            //Trace.WriteLine(ramp.ToString()+ " " + CalculDistanceAccConctinu(1, ramp).ToString());
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Red;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }

        public void DisplayCurveDisJ(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasJ.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = (CalculJerkJerkDisContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight / (2 * Math.PI / (ramp * 0.99)) * 0.5) / (2 * Math.PI) * (1 - ramp) / (0.25 / ramp) * Math.PI * 1.28 * 0.5 + 0.5 * canvasD.ActualHeight;
                    CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Green;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveDisA(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasA.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculAccelerationJerkDisContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight / (2 * Math.PI) * (1 - ramp)/(0.25/ramp)*0.5+0.5*canvasA.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Green;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveDisV(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasV.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculVitesseJerkDisContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight ;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Green;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveDisD(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasD.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = (CalculDistanceJerkDisContinu(i / canvasD.ActualWidth, ramp)) * canvasD.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Green;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }

        public void DisplayCurveJ(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasJ.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculJerkJerkContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight / (2 * Math.PI / (ramp * 0.99)) * 0.5 + 0.5 * canvasD.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Blue;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasJ.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveA(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasJ.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasJ.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasA.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculAccelJerkContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight * 0.25+0.5*canvasA.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Blue;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasA.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveV(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasV.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = CalculVitesseJerkContinu(i / canvasD.ActualWidth, ramp) * canvasD.ActualHeight * 1 / ramp;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Blue;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasV.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void DisplayCurveD(double ramp)
        {
            PointCollection CurveCollection = new PointCollection();
            Point myPoint = new Point();

            // Ma ligne du milieu
            myPoint.X = 0;
            myPoint.Y = canvasV.ActualHeight;
            CurveCollection.Add(myPoint);

            myPoint.X = 0;
            myPoint.Y = 0;// Ajoute dans une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            myPoint.X = canvasV.ActualWidth;
            myPoint.Y = 0;// Ajoute dans* une collection les coordonnées actuel
            CurveCollection.Add(myPoint);

            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = Brushes.White;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = CurveCollection; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLine);  // Dessine la Polyline

            //SinLinSinus premiere generation
            PointCollection CurveCollection2 = new PointCollection();

            for (int i = 0; i <= canvasD.ActualWidth; i++)
            {
                myPoint.X = i;
                myPoint.Y = (CalculDistanceJerkContinu(i / canvasD.ActualWidth, ramp)) * canvasD.ActualHeight;
                CurveCollection2.Add(myPoint);
            }
            Polyline myPolyLineSinLinSinus = new Polyline(); // Créer la Polyline
            myPolyLineSinLinSinus.StrokeThickness = 2;
            myPolyLineSinLinSinus.Stroke = Brushes.Blue;
            myPolyLineSinLinSinus.Opacity = 1;
            myPolyLineSinLinSinus.Points = CurveCollection2; // Remplie la Polyline de points
            canvasD.Children.Add(myPolyLineSinLinSinus);  // Dessine la Polyline

        }
        public void FactorisationDeCode(PointCollection tmp, Brush macouleur)
        {
            Polyline myPolyLine = new Polyline(); // Créer la Polyline
            myPolyLine.StrokeThickness = 1;
            myPolyLine.Stroke = macouleur;
            myPolyLine.Opacity = 1;
            myPolyLine.Points = tmp; // Remplie la Polyline de points
                                     // Dessine la Polyline
        }

        public double CalculJerkAccConctinu(double t, double ramp)
        {
            if (t == 0.01)
                return 1;
            else
                if (t < ramp)
                {
                    return 0;
                }
                else
                {
                if (t < (1 - ramp))
                {
                    return (0);
                }
                else
                    if (t == 0.5)
                        return -1; 
                    else
                    {
                        return -1;
                    }
            }
        }
        public double CalculAccelerationAccConctinu(double t, double ramp)
        {
            if (t < ramp)
            {
                return 1;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return 0;
                }
                else
                {
                    return -1;
                }
            }
        }
        public double CalculVitesseAccConctinu(double t, double ramp)
        {
            double correc = 1 / ramp;
            if (t < ramp)
            {
                return t * correc;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return ramp * correc;
                }
                else
                {
                    return (1-t) * correc;
                }
            }
        }

        public double CalculDistanceAccConctinu(double t, double ramp)
        {
            double correc = 1/ (ramp * ( 1- ramp)) ;

            if (t < ramp)
            {
                return t*t/2 * correc ;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return (t*ramp - ramp*ramp/2 ) * correc;
                }
                else
                {
                    //return 0.5;
                    return ( 
                        - (t - 1 + ramp)*(t - 1 + ramp) / 2 
                        + (t - 1 + ramp) * ramp
                        + (1 - ramp) * ramp - ramp * ramp / 2) * correc;
                }
            }
        }

        public double CalculJerkJerkDisContinu(double t, double ramp)
        {
            if (t < ramp)
            {
                return Math.Cos(Math.PI * t / ramp) * Math.PI * Math.PI / (2 * ramp * ramp - 2 * ramp * ramp * ramp);
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return (0);
                }
                else
                {
                    return -Math.Cos(-Math.PI * (t-1+ramp) / ramp) * -Math.PI * Math.PI / (2 * ramp * ramp - 2 * ramp * ramp * ramp);
                }
            }
        }
        public double CalculAccelerationJerkDisContinu(double t, double ramp)
        {
            if (t < ramp)
            {
                return  Math.Sin(Math.PI * t / ramp) * Math.PI/(2*ramp-2*ramp*ramp);
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return (0);
                }
                else
                {
                    return -Math.Sin(-Math.PI * (t-1+ramp) / ramp) * -Math.PI / (2 * ramp - 2 * ramp * ramp);
                }
            }
        }
        public double CalculVitesseJerkDisContinu(double t, double ramp)
        {
            if (t < ramp)
            {
                return (Math.Pow(2 - 2 * ramp, -1) - Math.Cos(Math.PI * t / ramp) * Math.Pow(2 - 2 * ramp, -1)) * (1 - ramp);
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return Math.Pow(1-ramp, -1) * (1 - ramp);
                }
                else
                {
                    return (Math.Pow(2 - 2 * ramp, -1) + Math.Cos(-Math.PI * (t - 1 + ramp) / ramp) * Math.Pow(2 -2 * ramp, -1)) * (1 - ramp);
                }
            }
        } 
        public double CalculDistanceJerkDisContinu(double t, double ramp)
        {
            if (t < ramp)
            {
                return (t / 2 - Sin(PI / ramp * t) / (PI / ramp * 2)) / (1 - ramp);
            }
            else
            {
                if (t < (1 - ramp))
                {
                    return (t - ramp / 2) / (1 - ramp);
                }
                else
                {
                    return ((t - 1 + ramp) / 2 - Sin(-PI * (t - 1 + ramp) / ramp) / (2 * PI / ramp) + 1 - 1.5 * ramp) / (1 - ramp);
                }
            }
        }

        public double CalculJerkJerkContinu(double t, double ramp)
        {
            Coeff = PI * 2 / ramp;
            double correc = 4 / (1 - 4 * Pow((0.5 - ramp), 2));
            double tmp = 0;
            if (t < ramp)
            {
                tmp = -Math.Sin(t * Coeff + Math.PI) * Coeff;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    tmp = 0;
                }
                else
                {
                    tmp = -Math.Sin((1 - t) * Coeff + Math.PI) * Coeff;
                }
            }
            return tmp;
        }
        public double CalculAccelJerkContinu(double t, double ramp)
        {
            Coeff = PI * 2 / ramp;
            double correc = 4 / (1 - 4 * Pow((0.5 - ramp), 2));
            double tmp = 0;
            if (t < ramp)
            {
                tmp = Math.Cos(t * Coeff + Math.PI) + 1;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    tmp = 0;
                }
                else
                {
                    tmp = -Math.Cos((1 - t) * Coeff + Math.PI) -1;
                }
            }
            return tmp;
        }
        public double CalculVitesseJerkContinu(double t, double ramp)
        {
            Coeff = PI * 2 / ramp;
            double correc = 4 / (1 - 4 * Pow((0.5 - ramp), 2));
            double tmp = 0;
            if (t < ramp)
            {
                tmp = -Math.Sin(t * Coeff) / Coeff + t;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    tmp = -Math.Sin(ramp * Coeff) / Coeff + ramp;
                }
                else
                {
                    tmp = -Math.Sin((1 - t) * Coeff) / Coeff + (1 - t);
                }
            }
            return tmp;
        }
        public double CalculDistanceJerkContinu(double t, double ramp)
        {
            Coeff = PI * 2 / ramp;
            double correc = 4 / (1 - 4 * Pow((0.5 - ramp), 2));
            double tmp = 0;
            if (t < ramp)
            {
                tmp = ((Cos(t * Coeff) - 1) / Pow(Coeff, 2) + Pow(t, 2) / 2) * correc;
            }
            else
            {
                if (t < (1 - ramp))
                {
                    tmp = (ramp * (t - ramp) + ramp * ramp / 2) * correc;
                }
                else
                {
                    tmp = ramp - 3 / 2 * ramp * ramp;
                    tmp -= (Cos((1 - t) * Coeff) - 1) / Pow(Coeff, 2) + Pow(1 - t, 2) / 2;
                    tmp *= correc;
                }
            }
            return tmp;
        }

        private void Compute(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            Compute();
        }

        private void recompute(object sender, SizeChangedEventArgs e)
        {
            Compute();
        }

        private void Compute()
        {
            canvasJ.Children.Clear();
            canvasA.Children.Clear();
            canvasV.Children.Clear();
            canvasD.Children.Clear();
            if (BtnM1.Background == Brushes.Lime)
            {
                if (BtnJ.Background == Brushes.Lime)
                {
                    DisplayCurveJAccContinu(rampSlider.Value);
                }
                if (BtnA.Background == Brushes.Lime)
                {
                    DisplayCurveAAccContinu(rampSlider.Value);
                }
                if (BtnV.Background == Brushes.Lime)
                {
                    DisplayCurveVAccContinu(rampSlider.Value);
                }
                if (BtnD.Background == Brushes.Lime)
                {
                    DisplayCurveDAccContinu(rampSlider.Value);
                }
            }
            if (BtnM2.Background == Brushes.Lime)
            {
                if (BtnJ.Background == Brushes.Lime)
                {
                    DisplayCurveDisJ(rampSlider.Value);
                }
                if (BtnA.Background == Brushes.Lime)
                {
                    DisplayCurveDisA(rampSlider.Value);
                }
                if (BtnV.Background == Brushes.Lime)
                {
                    DisplayCurveDisV(rampSlider.Value);
                }
                if (BtnD.Background == Brushes.Lime)
                {
                    DisplayCurveDisD(rampSlider.Value);
                }
            }
            if (BtnM3.Background == Brushes.Lime)
            {
                if (BtnJ.Background == Brushes.Lime)
                {
                    DisplayCurveJ(rampSlider.Value);
                }
                if (BtnA.Background == Brushes.Lime)
                {
                    DisplayCurveA(rampSlider.Value);
                }
                if (BtnV.Background == Brushes.Lime)
                {
                    DisplayCurveV(rampSlider.Value);
                }
                if (BtnD.Background == Brushes.Lime)
                {
                    DisplayCurveD(rampSlider.Value);
                }
            }

            TB2.Text = rampSlider.Value.ToString("0.00");
        }

        private void Click(object sender, RoutedEventArgs e)
        {
            Button Btn = (Button)sender;
            if (Btn.Background != Brushes.Lime)
            {
                Btn.Background = Brushes.Lime;
            }
            else
            {
                Btn.Background = Brushes.DarkGray;
            }
            Compute();
        }
    }
}